document.addEventListener('DOMContentLoaded', () => {
    const setup = document.getElementById('setup');
    const main = document.getElementById('stats-container');
    const ageIn = document.getElementById('age');
    const retIn = document.getElementById('retire');
    
    // Quotes
    const quotes = [
        "You are dying right now.", "Focus.", "Time is non-refundable.", 
        "What are you avoiding?", "This moment will never happen again.",
        "Stop scrolling. Start creating."
    ];

    function load() {
        chrome.storage.local.get(['tkr_age', 'tkr_retire'], (result) => {
            if (result.tkr_age && result.tkr_retire) {
                render(result.tkr_age, result.tkr_retire);
            } else {
                setup.style.display = 'block';
                main.style.display = 'none';
            }
        });
    }

    function render(age, retire) {
        setup.style.display = 'none';
        main.style.display = 'block';
        
        // Math
        const death = 82;
        const lifeGone = Math.min(100, Math.floor((age / death) * 100));
        const yearsLeft = Math.max(0, retire - age);
        
        document.getElementById('percent').innerText = `${lifeGone}% GONE`;
        document.getElementById('subtext').innerText = `${yearsLeft} YEARS UNTIL FREEDOM`;
        document.getElementById('quote').innerText = quotes[Math.floor(Math.random() * quotes.length)];
    }

    document.getElementById('save').addEventListener('click', () => {
        const a = ageIn.value;
        const r = retIn.value;
        if(a && r) {
            chrome.storage.local.set({tkr_age: a, tkr_retire: r}, load);
        }
    });

    document.getElementById('edit').addEventListener('click', () => {
        chrome.storage.local.clear(load);
    });

    load();
});